using System;
using Server;
using Server.Items;
using Server.Gumps;
using Server.Network;

namespace Server.Items
{
	public class QuestJar : Item
	{
		private bool m_Covetous;
		private bool m_Deceit;
		private bool m_Despise;
		private bool m_Destard;
		private bool m_Hythloth;
		private bool m_Shame;
		private bool m_Wrong;
		private bool m_Fire;
		private bool m_Ice;
		private bool m_Khaldun;
		private bool m_Toxic;
		private bool m_Mages;
		
		private bool m_isFull;
		private Mobile m_Owner;
		
		[CommandProperty(AccessLevel.GameMaster)]
		public bool Covetous { get { return m_Covetous; } set { m_Covetous = value; } }
		[CommandProperty(AccessLevel.GameMaster)]
		public bool Deceit { get { return m_Deceit; } set { m_Deceit = value; } }
		[CommandProperty(AccessLevel.GameMaster)]
		public bool Despise { get { return m_Despise; } set { m_Despise = value; } }
		[CommandProperty(AccessLevel.GameMaster)]
		public bool Destard { get { return m_Destard; } set { m_Destard = value; } }
		[CommandProperty(AccessLevel.GameMaster)]
		public bool Hythloth { get { return m_Hythloth; } set { m_Hythloth = value; } }
		[CommandProperty(AccessLevel.GameMaster)]
		public bool Shame { get { return m_Shame; } set { m_Shame = value; } }
		[CommandProperty(AccessLevel.GameMaster)]
		public bool Wrong { get { return m_Wrong; } set { m_Wrong = value; } }
		[CommandProperty(AccessLevel.GameMaster)]
		public bool Fire { get { return m_Fire; } set { m_Fire = value; } }
		[CommandProperty(AccessLevel.GameMaster)]
		public bool Ice { get { return m_Ice; } set { m_Ice = value; } }
		[CommandProperty(AccessLevel.GameMaster)]
		public bool Khaldun { get { return m_Khaldun; } set { m_Khaldun = value; } }
		[CommandProperty(AccessLevel.GameMaster)]
		public bool Toxic { get { return m_Toxic; } set { m_Toxic = value; } }
		[CommandProperty(AccessLevel.GameMaster)]
		public bool Mages { get { return m_Mages; } set { m_Mages = value; } }
		
		[CommandProperty(AccessLevel.GameMaster)]
		public bool isFull { get { return m_isFull; } set { m_isFull = value; } }
		[CommandProperty(AccessLevel.GameMaster)]
		public Mobile Owner { get { return m_Owner; } set { m_Owner = value; InvalidateProperties(); } }
		
		[Constructable]
		public QuestJar() : base( 4101 )
		{
			Weight = 0.1;
			LootType = LootType.Blessed;
			Name = "Podivna nadobka";
			Hue = 285;
			Light = LightType.Circle150;
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			if ( IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				if ( m_Owner == null )
					m_Owner = (Mobile)from;
				
				if ( from != m_Owner )
				{
					from.SendMessage( "Tato {0} neni tvoje!", this.Name );
				}
				else
				{
					from.SendGump( new QuestJarGump( from, this ) );
				}
			}
			else
				from.SendLocalizedMessage( 1060640 ); // That must be in your pack for you to use it.
		}
		
		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );
			
			if ( m_Owner != null )
				list.Add( 1072304, m_Owner.Name ); // owned by ~1_NAME~
		}
		
		public override bool DropToWorld( Mobile from, Point3D p )
		{
			from.SendLocalizedMessage( 1049343 ); // You can only drop quest items into the top-most level of your backpack while you still need them for your quest.
			return false;
		}

		public override bool DropToMobile( Mobile from, Mobile target, Point3D p )
		{
			from.SendLocalizedMessage( 1049344 ); // You decide against trading the item.  You still need it for your quest.
			return false;
		}

		public QuestJar( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 1 ); // version
			
			writer.Write( (bool) m_Toxic);
			writer.Write( (bool) m_Mages);
			
			writer.Write( (bool) m_Covetous);
			writer.Write( (bool) m_Deceit);
			writer.Write( (bool) m_Despise);
			writer.Write( (bool) m_Destard);
			writer.Write( (bool) m_Hythloth);
			writer.Write( (bool) m_Shame);
			writer.Write( (bool) m_Wrong);
			writer.Write( (bool) m_Fire);
			writer.Write( (bool) m_Ice);
			writer.Write( (bool) m_Khaldun);
			writer.Write( (bool) m_isFull);
			writer.Write( ( Mobile ) m_Owner);
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
			
			switch (version)
			{
				case 1:
					{
						m_Toxic = reader.ReadBool();
						m_Mages = reader.ReadBool();
						goto case 0;
					}
				case 0:
					{
						m_Covetous = reader.ReadBool();
						m_Deceit = reader.ReadBool();
						m_Despise = reader.ReadBool();
						m_Destard = reader.ReadBool();
						m_Hythloth = reader.ReadBool();
						m_Shame = reader.ReadBool();
						m_Wrong = reader.ReadBool();
						m_Fire = reader.ReadBool();
						m_Ice = reader.ReadBool();
						m_Khaldun = reader.ReadBool();
						m_isFull = reader.ReadBool();
						m_Owner = reader.ReadMobile();
						break;
					}
			}
			
			if ( version < 1 )
			{
				m_Toxic = m_Mages = false;
				ItemID = 4101;
				Hue = 285;
				m_isFull = false;
			}

			if (m_Covetous && m_Deceit && m_Despise && m_Destard && m_Hythloth && m_Shame && m_Wrong && m_Fire && m_Ice && m_Khaldun && m_Mages && m_Toxic )
			{
				m_isFull = true;
				ItemID = 4102;
				Hue = 43;
			}
		}
	}
}

//=== gump
namespace Server.Gumps
{
	public class QuestJarGump : Gump
	{
		private Mobile m_From;
		private QuestJar m_jar;

		public QuestJarGump( Mobile from, QuestJar jar ) : base( 60, 100 )
		{
			m_From = from;
			m_jar = jar;

			m_From.CloseGump( typeof( QuestJarGump ) );
			
			this.Closable=true;
			this.Disposable=true;
			this.Dragable=true;
			this.Resizable=false;
			this.AddPage(0);
			this.AddBackground(0, 0, 216, 182, 9250);
			this.AddLabel(56, 12, 32, @"Podivna nadobka");
			if ( m_jar.Covetous ) { this.AddImage(21, 45, 36); }
			this.AddLabel(35, 40, 0x480, @"Covetous");
			if ( m_jar.Deceit ) { this.AddImage(21, 65, 36); }
			this.AddLabel(35, 60, 0x480, @"Deceit");
			if ( m_jar.Despise ) { this.AddImage(21, 85, 36); }
			this.AddLabel(35, 80, 0x480, @"Despise");
			if ( m_jar.Destard ) { this.AddImage(21, 105, 36); }
			this.AddLabel(35, 100, 0x480, @"Destard");
			if ( m_jar.Hythloth ) { this.AddImage(21, 125, 36); }
			this.AddLabel(35, 120, 0x480, @"Hythloth");
			if ( m_jar.Toxic ) { this.AddImage(21, 145, 36); }
			this.AddLabel(35, 140, 0x480, @"Toxic Caves");
			if ( m_jar.Shame ) { this.AddImage(126, 45, 36); }
			this.AddLabel(140, 40, 0x480, @"Shame");
			if ( m_jar.Wrong ) { this.AddImage(126, 65, 36); }
			this.AddLabel(140, 60, 0x480, @"Wrong");
			if ( m_jar.Fire ) { this.AddImage(126, 85, 36); }
			this.AddLabel(140, 80, 0x480, @"Fire");
			if ( m_jar.Ice ) { this.AddImage(126, 105, 36); }
			this.AddLabel(140, 100, 0x480, @"Ice");
			if ( m_jar.Khaldun ) { this.AddImage(126, 125, 36); }
			this.AddLabel(140, 120, 0x480, @"Khaldun");
			if ( m_jar.Mages ) { this.AddImage(126, 145, 36); }
			this.AddLabel(140, 140, 0x480, @"Mage's");
		}
		
		public override void OnResponse( NetState state, RelayInfo info )
		{
		}
	}
}
